#include <Windows.h>
#include <stdio.h>
#include <io.h>
#include <string>
#include "L2ParamStack.h"

HINSTANCE hSelf;

typedef PVOID (__fastcall *TShowHtml) (UINT32 This, DWORD EDX, PVOID pStack);
TShowHtml ShowHtml = nullptr;

std::string GetParent( const std::string& path )
{
    if (path.empty())
        return path;

    auto idx = path.rfind( L'\\' );
    if (idx == path.npos)
        idx = path.rfind( L'/' );

    if (idx != path.npos)
        return path.substr( 0, idx );
    
	return path;
}

std::wstring AnsiToWstring( const std::string& input, DWORD locale /*= CP_ACP*/ )
{
    wchar_t buf[8192 * 2] = { 0 };
    MultiByteToWideChar( locale, 0, input.c_str(), (int)input.length(), buf, ARRAYSIZE( buf ) );
    return buf;
}

std::wstring UTF8ToWstring( const std::string& str )
{
    return AnsiToWstring( str, CP_UTF8 );
}

int __cdecl SleepStub(float delay)
{
	if(delay > .0f)
		Sleep(50);

	return 0;
}

void DisableLazyMode(void)
{
	BYTE *LazyMode  = (BYTE *)GetProcAddress(GetModuleHandle(TEXT("Core.dll")), "?appSleep@@YAXM@Z");

	if(!LazyMode)
		return;
	
	ULONG oldProtect;
	if(!VirtualProtect(LazyMode, 5, PAGE_READWRITE, &oldProtect))
		return;

	*LazyMode = 0xE9;
	*(int*) (LazyMode + 1) = (BYTE*)SleepStub - (LazyMode + 5);

	VirtualProtect(LazyMode, 5, oldProtect, &oldProtect);
}

void Main()
{
	L2ParamStack::Hook();

	MessageBoxA(0, "L2HtmlTester by Akumu (c) 2015", "forummaxi.ru", MB_OK | MB_ICONINFORMATION);

	HMODULE NWindow = NULL;
	while(!NWindow)
	{
		NWindow = GetModuleHandle(TEXT("NWindow.dll"));
		Sleep(100);
	}

	HMODULE hEngine = NULL;
	while(!hEngine)
	{
		hEngine = GetModuleHandle(TEXT("engine.dll"));
		Sleep(100);
	}

	DWORD GL2Console = (DWORD)GetProcAddress(hEngine, "?GL2Console@@3PAVUL2ConsoleWnd@@A");
	DWORD pL2Console;
	
	get_p:
	pL2Console = *(DWORD*)GL2Console;

	if(!pL2Console)
	{
		Sleep(1000);
		goto get_p;
	}

	//printf("NWindow: %08X\n", NWindow);
	//printf("pL2Console: %08X\n", pL2Console);

	DWORD dwFuncAddr = (DWORD)NWindow + 0x16d6f0;
	ShowHtml = (TShowHtml)dwFuncAddr;

	//printf("ShowHtml: %08X\n", ShowHtml);

	DisableLazyMode();

	char szDir[MAX_PATH] = {0};
	GetModuleFileNameA(hSelf, szDir, MAX_PATH);

	std::string path = GetParent(szDir);
	path += "\\data.html";

	HANDLE hFile = CreateFileA(path.c_str(), GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, CREATE_NEW | OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if(hFile != INVALID_HANDLE_VALUE)
	{
		DWORD64 ftStart;
		GetFileTime(hFile, NULL, NULL, (LPFILETIME)&ftStart);

		//printf("File time: %I64d\n", ftStart);

		while(true)
		{
			Sleep(100);

			DWORD64 ftNow;
			if(!GetFileTime(hFile, NULL, NULL, (LPFILETIME)&ftNow))
			{
				//printf("GetFileTime failed (%d)\n", GetLastError());
				continue;
			}

			if(ftStart != ftNow)
			{
				ftStart = ftNow;
				//printf("File time: %I64d\n", ftStart);

				SetFilePointer(hFile, 0, 0, FILE_BEGIN);

				DWORD dwFileSize(0);
				if((dwFileSize = GetFileSize(hFile, NULL)) == INVALID_FILE_SIZE)
				{
					//printf("GetFileSize failed (%d)\n", GetLastError());
					continue;
				}

				//printf("New file size: %d\n", dwFileSize);

				PBYTE pData = (PBYTE)malloc(dwFileSize + 2);
				ZeroMemory(pData, dwFileSize + 2);

				DWORD dwDataRead(0);
				if(ReadFile(hFile, pData, dwFileSize, &dwDataRead, NULL) && dwDataRead == dwFileSize)
				{
					std::string str = std::string((PCHAR)pData);
					std::wstring html = UTF8ToWstring(str);

					//wprintf(L"%s\n", html.c_str());

					L2ParamStack stack = L2ParamStack(0xA);
					stack.PushBack((unsigned short*)html.c_str());
					stack.PushBack((PVOID)0);

					//printf("calling...\n");
					ShowHtml(pL2Console, (DWORD)ShowHtml, &stack);
				}
				//else
					//printf("Could not read new data! (%d)\n", GetLastError());

				free(pData);
			}
		}
	}
	//else
		//printf("Can not open file! (%d)\n", GetLastError());
}

BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID)
{
	if (fdwReason == DLL_PROCESS_ATTACH)
	{
		hSelf = hinstDLL;
		DisableThreadLibraryCalls(hinstDLL);

		/*AllocConsole();
		stdout->_file = _open_osfhandle(reinterpret_cast<intptr_t>(GetStdHandle(STD_OUTPUT_HANDLE)), 0);
		stdin->_file  = _open_osfhandle(reinterpret_cast<intptr_t>(GetStdHandle(STD_INPUT_HANDLE)),  0);
		stderr->_file = _open_osfhandle(reinterpret_cast<intptr_t>(GetStdHandle(STD_ERROR_HANDLE)),  0);*/

		CreateThread(nullptr, NULL, reinterpret_cast<LPTHREAD_START_ROUTINE>(Main), nullptr, NULL, nullptr);
	}

	return TRUE;
}