﻿using System;

namespace PathnodeGenerator
{
    public enum GeoDirection
    {
        N, NE, E, SE, S, SW, W, NW
    }

    public enum BlockType
    {
        FLAT, COMPLEX, MULTILEVEL
    }

    public enum NSWE
    {
        NONE, 
        E, W, S, N, WE, SE, SW, SWE, NE, NW, NWE, NS, NSE, NSW, ALL, 
        FAKE
    }

    public static class NsweHelper
    {
        public static bool Contains(NSWE n, NSWE v)
        {
            if (n == v || n == NSWE.ALL)
                return true;

            switch (v)
            {
                case NSWE.W:
                    return !(n != NSWE.NE && n != NSWE.SE && n != NSWE.WE && n != NSWE.NWE && n != NSWE.NSE && n != NSWE.SWE);

                case NSWE.S:
                    return !(n != NSWE.WE && n != NSWE.SW && n != NSWE.NW && n != NSWE.NWE && n != NSWE.SWE && n != NSWE.NSW);

                case NSWE.N:
                    return !(n != NSWE.SE && n != NSWE.NS && n != NSWE.SW && n != NSWE.NSW && n != NSWE.NSE && n != NSWE.SWE);

                case NSWE.WE:
                    return !(n != NSWE.NE && n != NSWE.NS && n != NSWE.NW && n != NSWE.NWE && n != NSWE.NSE && n != NSWE.NSW);

                case NSWE.SE:
                    return !(n != NSWE.NWE && n != NSWE.SWE);

                case NSWE.SW:
                    return !(n != NSWE.NSE && n != NSWE.SWE);

                case NSWE.SWE:
                    return !(n != NSWE.NSW && n != NSWE.SWE);

                case NSWE.NE:
                case NSWE.NS:
                default:
                    return true;

                case NSWE.NW:
                    return !(n != NSWE.NWE && n != NSWE.NSE);

                case NSWE.NWE:
                    return !(n != NSWE.NWE && n != NSWE.NSW);

                case NSWE.NSE:
                    return n == NSWE.NSE || n == NSWE.NSW;
            }
        }
    }
}
