﻿using System;
using System.Collections.Generic;
using System.IO;

namespace PathnodeGenerator
{
    class MultiNode
    {
        List<Node> _nodes = new List<Node>();

        public void addNode(Node n)
        {
            _nodes.Add(n);
        }

        public Node getNode(byte n)
        {
            return _nodes[n];
        }

        public byte getSize()
        {
            return (byte) _nodes.Count;
        }

        public byte[] getData()
        {
            int i = 0;

            byte[] echo = new byte[1 + _nodes.Count * 10];

            echo[i++] = (byte)_nodes.Count;

            
            foreach (Node n in _nodes)
            {
                byte[] data = n.getData();
                Array.Copy(data, 0, echo, i, data.Length); 
                i += data.Length;
            }

            return echo;
        }

        public List<Node> getNodes()
        {
            return _nodes;
        }
    }
}
