﻿using System;
using Geo;
using PathnodeGenerator;
using System.IO;

namespace PathnodeGenerator
{
    class GeoRegion
    {
        private GeoBlock[][] blocks;
        private byte numberOfLayers = 0;
        private byte Rx;
        private byte Ry;
        private GeoRegion.MinMaxH minmax;

        public GeoBlock getBlock(short x, short y)
        {
            return blocks[x][y];
        }

        public GeoCell getCellAt(int x, int y)
        {
            return getBlock((short)(x / 8), (short)(y / 8)).getCell(Convert.ToByte(x % 8), Convert.ToByte(y % 8));
        }

        public GeoRegion(string f)
        {
            try
            {
                GeoBuffer geo = new GeoBuffer(File.ReadAllBytes(f));
                minmax = new GeoRegion.MinMaxH();

                GeoCell cells;

                short y, type, layers;
                byte y2, x2, l, temp;

                string name = Path.GetFileNameWithoutExtension(f);

                //Console.WriteLine("GeoRegion: file name is " + name);

                Rx = Convert.ToByte(name.Substring(0, 2));
                Ry = Convert.ToByte(name.Substring(3, 2));

                //Console.WriteLine("GeoRegion: X: " + Rx + ", Y: " + Ry);

                blocks = new GeoBlock[256][];

                for (y = 0; y < 256; ++y)
                {
                    blocks[y] = new GeoBlock[256];

                    for (type = 0; type < 256; ++type)
                    {
                        blocks[y][type] = new GeoBlock();

                        BlockType z = (BlockType)geo.getByte();

                        switch (z)
                        {
                            case BlockType.FLAT:
                            {
                                layers = geo.getShort();

                                cells = new GeoCell();
                                cells.fillData(layers, blocks[y][type]);
                                minmax.setMinMax(Convert.ToByte(0), cells.getZ(Convert.ToByte(0)));
                                blocks[y][type].fillDataFlat(y, type, z, cells);
                                break;
                            }

                            case BlockType.COMPLEX:
                            {
                                GeoCell[][] var = new GeoCell[8][];

                                for (x2 = 0; x2 < 8; ++x2)
                                {
                                    var[x2] = new GeoCell[8];

                                    for (y2 = 0; y2 < 8; ++y2)
                                    {
                                        layers = geo.getShort();

                                        var[x2][y2] = new GeoCell();
                                        var[x2][y2].fillData(layers, blocks[y][type]);
                                        minmax.setMinMax(Convert.ToByte(0), var[x2][y2].getZ(Convert.ToByte(0)));
                                    }
                                }

                                blocks[y][type].fillData(y, type, z, var);
                                break;
                            }

                            default:
                            {
                                GeoCell[][] var = new GeoCell[8][];

                                for (y2 = 0; y2 < 8; ++y2)
                                {
                                    var[y2] = new GeoCell[8];

                                    for (temp = 0; temp < 8; ++temp)
                                    {
                                        byte var28 = geo.getByte();

                                        short[] var32 = new short[var28];

                                        if (var28 > numberOfLayers)
                                        {
                                            this.numberOfLayers = var28;
                                        }

                                        for (l = 0; l != var28; ++l)
                                        {
                                            var32[l] = geo.getShort();

                                        }

                                        var[y2][temp] = new GeoCell();
                                        var[y2][temp].fillDataMulti(var32, blocks[y][type]);

                                        for (byte l1 = 0; l1 < var32.Length; ++l1)
                                        {
                                            minmax.setMinMax(l1, var[y2][temp].getZ(l1));
                                        }
                                    }
                                }

                                blocks[y][type].fillData(y, type, z, var);
                                break;
                            }
                        }
                    }
                }

                //Console.WriteLine("GeoRegion: size: " + blocks.Length);
            }
            catch(Exception e)
            {
                //Console.WriteLine("bbbb");
                //Console.WriteLine("GeoRegion: Exception: " + e.Message);
            }
        }

        public byte getX()
        {
            return Rx;
        }

        public byte getY()
        {
            return Ry;
        }

        class MinMaxH
        {

            private short[] zmin = new short[] { (short)32767 };
            private short[] zmax = new short[] { (short)-32768 };
            private byte numberOfLayers = 1;


            public short getMin(byte layer)
            {
                return this.zmin[layer];
            }

            public short getMax(byte layer)
            {
                return this.zmax[layer];
            }

            public bool setMinMax(byte layer, short value)
            {
                if (layer + 1 > this.numberOfLayers)
                {
                    short[] res = new short[layer + 1];
                    short[] maxT = new short[layer + 1];

                    byte i;
                    for (i = 0; i < this.numberOfLayers; ++i)
                    {
                        res[i] = this.zmin[i];
                        maxT[i] = this.zmax[i];
                    }

                    for (i = this.numberOfLayers; i < layer + 1; ++i)
                    {
                        res[i] = 32767;
                        maxT[i] = -32768;
                    }

                    this.zmin = res;
                    this.zmax = maxT;
                    this.numberOfLayers = Convert.ToByte(layer + 1);
                }

                bool var6 = false;
                if (value < this.zmin[layer])
                {
                    this.zmin[layer] = value;
                    var6 = true;
                }

                if (value > this.zmax[layer])
                {
                    this.zmax[layer] = value;
                    var6 = true;
                }

                return var6;
            }
        }
    }
}
