﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using Geo;
using PathnodeGenerator;

namespace PathNode
{
    class Map
    {
        MultiNode[][] _multinodes;
        private static int[] Direction = new int[]{1, 2, 3, 4, 5, 6, 7, 8};

        public void generatePathNode()
        {
            GeoRegion gr = Geodata.getInstance().getRegion();
            _multinodes = new MultiNode[256][];

            for (short j = 0; j < 256; ++j)
            {
                _multinodes[j] = new MultiNode[256];

                for (short i = 0; i < 256; ++i)
                {
                    _multinodes[j][i] = new MultiNode();
                    MultiNode mNode = _multinodes[j][i];

                    GeoBlock gb = gr.getBlock(i, j);

                    byte amountOfNodes = gb.getAmountOfNodes();
                    byte k;

                    for (k = 0; k < amountOfNodes; ++k)
                    {
                        

                        Node node = new Node(gb.getNodeHeight(k));
                        Pair position;

                        short tz;
                        bool linkExists;
                        byte l;

                        GeoCell cell;

                        if (j == 0)
                        {
                            node.setN(Convert.ToByte(1));
                            node.setNE(Convert.ToByte(1));
                            node.setNW(Convert.ToByte(1));
                        }
                        else
                        {
                            position = new Pair(i * 8 + 3, 8 * j + 3);
                            tz = gr.getCellAt(i * 8 + 3, 8 * j + 3).getZ(k);
                            linkExists = true;

                            for (l = 0; l < getNumOfCells(GeoDirection.N); ++l)
                            {
                                changePosition(l, GeoDirection.N, position);

                                cell = gr.getCellAt(position.getX(), position.getY());
                                tz = gr.getCellAt(position.getX(), position.getY()).getHeightForNearestCell(tz);

                                if (!NsweHelper.Contains(cell.getNSWEforNearestCell(tz), NSWE.N))
                                {
                                    node.setN(Convert.ToByte(0));
                                    linkExists = false;
                                    break;
                                }
                            }

                            if (linkExists)
                            {
                                l = gr.getCellAt(i * 8 + 3, 8 * (j - 1) + 3).getLayerByZ(tz);
                                node.setN(Convert.ToByte(l + 1));
                            }
                        }
                        
                        if (j != 0 && i != 255)
                        {
                            position = new Pair(i * 8 + 3, 8 * j + 3);
                            tz = gr.getCellAt(i * 8 + 3, 8 * j + 3).getZ(k);
                            linkExists = true;

                            for (l = 0; l < this.getNumOfCells(GeoDirection.NE); ++l)
                            {
                                this.changePosition(l, GeoDirection.NE, position);
                                cell = gr.getCellAt(position.getX(), position.getY());
                                tz = gr.getCellAt(position.getX(), position.getY()).getHeightForNearestCell(tz);

                                if (!NsweHelper.Contains(cell.getNSWEforNearestCell(tz), NSWE.NE))
                                {
                                    node.setNE((byte)0);
                                    linkExists = false;
                                    break;
                                }
                            }

                            if (linkExists)
                            {
                                l = gr.getCellAt((i + 1) * 8 + 3, 8 * (j - 1) + 3).getLayerByZ(tz);
                                node.setNE((byte)(l + 1));
                            }
                        }
                        else
                        {
                            node.setNE(Convert.ToByte(1));
                        }
                        
                        if (i == 255)
                        {
                            node.setE(Convert.ToByte(1));
                            node.setNE(Convert.ToByte(1));
                            node.setSE(Convert.ToByte(1));
                        }
                        else
                        {
                            position = new Pair(i * 8 + 3, 8 * j + 3);
                            tz = gr.getCellAt(i * 8 + 3, 8 * j + 3).getZ(k);
                            linkExists = true;

                            for (l = 0; l < getNumOfCells(GeoDirection.E); ++l)
                            {
                                changePosition(l, GeoDirection.E, position);
                                cell = gr.getCellAt(position.getX(), position.getY());
                                tz = gr.getCellAt(position.getX(), position.getY()).getHeightForNearestCell(tz);

                                if (!NsweHelper.Contains(cell.getNSWEforNearestCell(tz), NSWE.E))
                                {
                                    node.setE(Convert.ToByte(0));
                                    linkExists = false;
                                    break;
                                }
                            }

                            if (linkExists)
                            {
                                l = gr.getCellAt((i + 1) * 8 + 3, 8 * j + 3).getLayerByZ(tz);
                                node.setE(Convert.ToByte(l + 1));
                            }
                        }
                        
                        if (j != 255 && i != 255)
                        {
                            position = new Pair(i * 8 + 3, 8 * j + 3);
                            tz = gr.getCellAt(i * 8 + 3, 8 * j + 3).getZ(k);
                            linkExists = true;

                            for (l = 0; l < getNumOfCells(GeoDirection.SE); ++l)
                            {
                                changePosition(l, GeoDirection.SE, position);
                                cell = gr.getCellAt(position.getX(), position.getY());
                                tz = gr.getCellAt(position.getX(), position.getY()).getHeightForNearestCell(tz);


                                if (!NsweHelper.Contains(cell.getNSWEforNearestCell(tz), NSWE.SE))
                                {
                                    node.setSE(Convert.ToByte(0));
                                    linkExists = false;
                                    break;
                                }
                            }

                            if (linkExists)
                            {
                                l = gr.getCellAt((i + 1) * 8 + 3, 8 * (j + 1) + 3).getLayerByZ(tz);
                                node.setSE(Convert.ToByte(l + 1));
                            }
                        }
                        else
                        {
                            node.setSE(Convert.ToByte(1));
                        }
                        
                        if (j == 255)
                        {
                            node.setS(Convert.ToByte(1));
                            node.setSE(Convert.ToByte(1));
                            node.setSW(Convert.ToByte(1));
                        }
                        else
                        {
                            position = new Pair(i * 8 + 3, 8 * j + 3);
                            tz = gr.getCellAt(i * 8 + 3, 8 * j + 3).getZ(k);
                            linkExists = true;

                            for (l = 0; l < getNumOfCells(GeoDirection.S); ++l)
                            {
                                changePosition(l, GeoDirection.S, position);
                                cell = gr.getCellAt(position.getX(), position.getY());
                                tz = gr.getCellAt(position.getX(), position.getY()).getHeightForNearestCell(tz);

                                if (!NsweHelper.Contains(cell.getNSWEforNearestCell(tz), NSWE.S))
                                {
                                    node.setS(Convert.ToByte(0));
                                    linkExists = false;
                                    break;
                                }
                            }

                            if (linkExists)
                            {
                                l = gr.getCellAt(i * 8 + 3, 8 * (j + 1) + 3).getLayerByZ(tz);
                                node.setS(Convert.ToByte(l + 1));
                            }
                        }

                        if (i != 0 && j != 255)
                        {
                            position = new Pair(i * 8 + 3, 8 * j + 3);
                            tz = gr.getCellAt(i * 8 + 3, 8 * j + 3).getZ(k);
                            linkExists = true;

                            for (l = 0; l < getNumOfCells(GeoDirection.SW); ++l)
                            {
                                changePosition(l, GeoDirection.SW, position);
                                cell = gr.getCellAt(position.getX(), position.getY());
                                tz = gr.getCellAt(position.getX(), position.getY()).getHeightForNearestCell(tz);

                                if (!NsweHelper.Contains(cell.getNSWEforNearestCell(tz), NSWE.SW))
                                {
                                    node.setSW(Convert.ToByte(0));
                                    linkExists = false;
                                    break;
                                }
                            }

                            if (linkExists)
                            {
                                l = gr.getCellAt((i - 1) * 8 + 3, 8 * (j + 1) + 3).getLayerByZ(tz);
                                node.setSW(Convert.ToByte(l + 1));
                            }
                        }
                        else
                        {
                            node.setSW(Convert.ToByte(1));
                        }

                        if (i == 0)
                        {
                            node.setW(Convert.ToByte(1));
                            node.setNW(Convert.ToByte(1));
                            node.setSW(Convert.ToByte(1));
                        }
                        else
                        {
                            position = new Pair(i * 8 + 3, 8 * j + 3);
                            tz = gr.getCellAt(i * 8 + 3, 8 * j + 3).getZ(k);
                            linkExists = true;

                            for (l = 0; l < getNumOfCells(GeoDirection.W); ++l)
                            {
                                changePosition(l, GeoDirection.W, position);
                                cell = gr.getCellAt(position.getX(), position.getY());
                                tz = gr.getCellAt(position.getX(), position.getY()).getHeightForNearestCell(tz);

                                if (!NsweHelper.Contains(cell.getNSWEforNearestCell(tz), NSWE.W))
                                {
                                    node.setW(Convert.ToByte(0));
                                    linkExists = false;
                                    break;
                                }
                            }

                            if (linkExists)
                            {
                                l = gr.getCellAt((i - 1) * 8 + 3, 8 * j + 3).getLayerByZ(tz);
                                node.setW(Convert.ToByte(l + 1));
                            }
                        }

                        if (i != 0 && j != 0)
                        {
                            position = new Pair(i * 8 + 3, 8 * j + 3);
                            tz = gr.getCellAt(i * 8 + 3, 8 * j + 3).getZ(k);
                            linkExists = true;

                            for (l = 0; l < this.getNumOfCells(GeoDirection.NW); ++l)
                            {
                                this.changePosition(l, GeoDirection.NW, position);
                                cell = gr.getCellAt(position.getX(), position.getY());
                                tz = gr.getCellAt(position.getX(), position.getY()).getHeightForNearestCell(tz);

                                if (!NsweHelper.Contains(cell.getNSWEforNearestCell(tz), NSWE.NW))
                                {
                                    node.setNW(Convert.ToByte(0));
                                    linkExists = false;
                                    break;
                                }
                            }

                            if (linkExists)
                            {
                                l = gr.getCellAt((i - 1) * 8 + 3, 8 * (j - 1) + 3).getLayerByZ(tz);
                                node.setNW(Convert.ToByte(l + 1));
                            }
                        }
                        else
                        {
                            node.setNW(Convert.ToByte(1));
                        }

                        mNode.addNode(node);
                    }

                    /*file.WriteLine("[{0}][{1}]: mNode size: {2}", j, i, mNode.getSize());
                    
                    foreach(Node n in mNode.getNodes())
                    {
                        file.Write("\tz: {0}", n.getZ());
                        file.WriteLine(" -> {0} {1} {2} {3} {4} {5} {6} {7}", n.N, n.NE, n.NW, n.S, n.SE, n.SW, n.W, n.E);
                    }*/
                }
            }

            //file.Close();

            savePathNode(Geodata.getInstance().ostr + "/" + gr.getX() + "_" + gr.getY() + ".pn");
        }

        // проверен
        public void savePathNode(string f)
        {
            using (BinaryWriter bw = new BinaryWriter(File.Open(f, FileMode.Create)))
            {
                for (int j = 0; j < 256; ++j)
                {
                    for (int i = 0; i < 256; ++i)
                    {
                        byte[] b = _multinodes[j][i].getData();
                        bw.Write(b, 0, b.Length);
                    }
                }

                bw.Close();
            }
        }

        // проверен
        private void changePosition(byte order, GeoDirection dir, Pair p)
        {
            if (order != 0)
            {
                switch (get_Direction()[(int)dir])
                {
                    case 1:
                        if (order % 2 == 1)
                        {
                            p.increaseX();
                        }
                        else
                        {
                            p.decreaseX();
                            p.decreaseY();
                        }
                        return;

                    case 2:
                        if (order % 3 == 1)
                        {
                            p.increaseX();
                        }
                        else if (order % 3 == 2)
                        {
                            p.increaseY();
                        }
                        else
                        {
                            p.decreaseY();
                            p.decreaseY();
                        }
                        return;

                    case 3:
                        if (order % 2 == 1)
                        {
                            p.increaseY();
                        }
                        else
                        {
                            p.decreaseY();
                            p.increaseX();
                        }
                        return;

                    case 4:
                        if (order % 3 == 1)
                        {
                            p.increaseX();
                        }
                        else if (order % 3 == 2)
                        {
                            p.decreaseX();
                            p.increaseY();
                        }
                        else
                        {
                            p.increaseX();
                        }
                        return;

                    case 5:
                        if (order % 2 == 1)
                        {
                            p.increaseX();
                        }
                        else
                        {
                            p.decreaseX();
                            p.increaseY();
                        }
                        return;

                    case 6:
                        if (order % 3 == 1)
                        {
                            p.increaseY();
                        }
                        else if (order % 3 == 2)
                        {
                            p.increaseX();
                        }
                        else
                        {
                            p.decreaseX();
                            p.decreaseX();
                        }
                        return;

                    case 7:
                        if (order % 2 == 1)
                        {
                            p.increaseY();
                        }
                        else
                        {
                            p.decreaseY();
                            p.decreaseX();
                        }
                        return;

                    case 8:
                        if (order % 3 == 1)
                        {
                            p.increaseX();
                        }
                        else if (order % 3 == 2)
                        {
                            p.decreaseX();
                            p.increaseY();
                        }
                        else
                        {
                            p.decreaseX();
                            p.decreaseY();
                            p.decreaseY();
                        }
                        return;
                }
            }
        }

        private byte getNumOfCells(GeoDirection dir)
        {
            switch (get_Direction()[(int)dir])
            {
                case 1:
                case 3:
                case 5:
                case 7:
                    return (byte)16;
                case 2:
                case 4:
                case 6:
                case 8:
                    return (byte)24;
                default:
                    return (byte)0;
            }
        }

        static int[] get_Direction()
        {
            return Direction;
        }
    }
}
