﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using Geo;
using PathNode;

namespace PathnodeGenerator
{
    public partial class Main : Form
    {
        public Main()
        {
            InitializeComponent();
        }

        // input/output buttons
        FolderBrowserDialog ifbd, ofbd;
        string[] files = null;

        // config
        INI Config = null;

        bool breaking = false;

        private void Form1_Load(object sender, EventArgs e)
        {
            ifbd = new FolderBrowserDialog();
            ofbd = new FolderBrowserDialog();

            if (File.Exists("./pngen.ini"))
            {
                Config = new INI("./pngen.ini");

                string input = Config.Read("PNGen", "InputDir");
                string output = Config.Read("PNGen", "OutputDir");

                if (!string.IsNullOrEmpty(input) && Directory.Exists(input))
                {
                    files = Directory.GetFiles(input, "*.l2j");

                    if (files.Length < 1)
                    {
                        files = null;
                        MessageBox.Show("Папка пуста!");
                    }
                    else
                    {
                        ifbd.SelectedPath = input;
                        textBox1.Text = input;
                    }
                }

                if (!string.IsNullOrEmpty(output) && Directory.Exists(output))
                {
                    ofbd.SelectedPath = output;
                    textBox2.Text = output;
                }
            }
            else
            {
                File.Create("./pngen.ini").Close();
                Config = new INI("./pngen.ini");
            }
        }

        private void istrSelectPath(string s)
        {
            textBox1.Text = s;

            if (Config != null)
                Config.Write("PNGen", "InputDir", s);
        }

        private void ostrSelectPath(string s)
        {
            textBox2.Text = s;

            if (Config != null)
                Config.Write("PNGen", "OutputDir", s);
        }

        private void textBox1_Click(object sender, EventArgs e)
        {
            button1_Click(sender, e);
        }

        // Input button
        private void button1_Click(object sender, EventArgs e)
        {
            start:
            if (ifbd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                files = Directory.GetFiles(ifbd.SelectedPath, "*.l2j");

                if (files.Length < 1)
                {
                    MessageBox.Show("Папка пуста!");
                    goto start;
                }

                istrSelectPath(ifbd.SelectedPath);
            }
        }

        private void textBox2_Click(object sender, EventArgs e)
        {
            button2_Click(sender, e);
        }

        // Output button
        private void button2_Click(object sender, EventArgs e)
        {
            if (ofbd.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                ostrSelectPath(ofbd.SelectedPath);
            }
        }

        // START button
        private void button3_Click(object sender, EventArgs e)
        {
            if (ifbd.SelectedPath.Length < 1)
            {
                MessageBox.Show("Папка с геодатой не указана!");
                return;
            }

            if (ofbd.SelectedPath.Length < 1)
            {
                MessageBox.Show("Папка для Pathnode не указана!");
                return;
            }

            richTextBox1.Text = null;
            button1.Enabled = false;
            button2.Enabled = false;
            button3.Text = "Работаю...";
            button3.Enabled = false;
            button4.Enabled = true;

            Geodata.getInstance().setInputDir(ifbd.SelectedPath);
            Geodata.getInstance().setOutputDir(ofbd.SelectedPath);

            progressBar1.Maximum = files.Length;

            backgroundWorker1.RunWorkerAsync();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            breaking = true;
            button3.Text = "Остановка...";
            button4.Enabled = false;
            button4.Text = "Остановка...";
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            string format = "[HH:mm:ss]";

            foreach (string file in files)
            {
                string name = file.Substring(ifbd.SelectedPath.Length + 1, 5);
                DateTime time = DateTime.Now;

                richTextBox1.Text = time.ToString(format) + " Creating " + name + ".pn\n" + richTextBox1.Text;

                progressBar1.Value++;

                Geodata.getInstance().setFile(file);

                Map m = new Map();
                m.generatePathNode();

                if (breaking)
                {
                    breaking = false;
                    return;
                }
            }
        }

        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            progressBar1.Value = 0;
            button1.Enabled = true;
            button2.Enabled = true;
            button3.Text = "START";
            button3.Enabled = true;
            button4.Enabled = false;
            button4.Text = "STOP";
        }

        private void toolStripStatusLabel2_Click(object sender, EventArgs e)
        {
            ;lock,.;'
        }
    }
}
