﻿using System;
using Geo;

namespace PathnodeGenerator
{
    class GeoCell
    {
        private short[] z;
        private GeoBlock block;

        public void fillData(short _z, GeoBlock b)
        {
            z = new short[1];
            z[0] = _z;
            block = b;
        }

        public void fillDataMulti(short[] _z, GeoBlock b)
        {
            z = _z;
            block = b;
        }

        public bool exists(byte layer)
        {
            return layer < this.z.Length;
        }

        public short getZ(byte layer)
        {
            if (!exists(layer))
            {
                return -32768;
            }

            if (block.getType() != BlockType.FLAT)
            {
                return (short)((short)(this.z[layer] & '\ufff0') >> 1);
            }
            else
            {
                return (short)(z[layer] & '\ufff0');
            }
        }

        public void setZ(byte layer, short newZ)
        {
            if (block.getType() != BlockType.FLAT)
            {
                z[layer] = (short)(z[layer] & 15 | newZ << 1 & '\ufff0');
            }
            else
            {
                z[layer] = newZ;
            }
        }

        public GeoBlock getBlock()
        {
            return block;
        }

        public NSWE getNSWE(byte layer)
        {
            return !exists(layer) ? NSWE.FAKE : (block.getType() == BlockType.FLAT ? NSWE.ALL : (NSWE)(z[layer] & 15));
        }

        public byte getLayers()
        {
            return (byte)z.Length;
        }

        public int checkLayersSort()
        {
            if (z.Length == 1)
                return 0;
            else
                for (int i = 1; i < z.Length; ++i)
                    if (z[i] > z[i - 1])
                        return 1;

            return 0;
        }

        public NSWE getNSWEforNearestCell(short height)
        {
            for (byte layer = 0; layer < z.Length; ++layer)
                if (getZ(layer) < height + 10)
                    return getNSWE(layer);

            return NSWE.NONE;
        }

        public short getHeightForNearestCell(short height)
        {
            for (byte layer = 0; layer < z.Length; ++layer)
            {
                if (getZ(layer) < height + 32)
                {
                    return getZ(layer);
                }
            }

            return getZ((byte)(z.Length - 1));
        }

        public byte getLayerByZ(short nz)
        {
            for (byte i = 0; i < z.Length; ++i)
                if (getZ(i) == nz)
                    return i;

            return 0;
        }
    }
}
