﻿using System;
using Geo;

namespace PathnodeGenerator
{
    class GeoBlock
    {
        private short blockX;
        private short blockY;

        private GeoCell[][] cells;
        private GeoCell flat_cell;

        private BlockType type;

        public GeoCell getCell(byte x, byte y)
        {
            return type == BlockType.FLAT ? flat_cell : cells[x][y];
        }

        public void fillDataEmptyFlatBlock(short x, short y)
        {
            blockX = x;
            blockY = y;
            type = BlockType.FLAT;
            flat_cell = new GeoCell();
            flat_cell.fillDataMulti(new short[0], this);
        }

        public void fillData(short x, short y, BlockType t, GeoCell[][] cell)
        {
            blockX = x;
            blockY = y;
            type = t;
            cells = cell;
        }

        public void fillDataFlat(short x, short y, BlockType t, GeoCell cell)
        {
            blockX = x;
            blockY = y;
            type = t;
            flat_cell = cell;
        }

        public short getX()
        {
            return blockX;
        }

        public short getY()
        {
            return blockY;
        }

        public BlockType getType()
        {
            return type;
        }

        public byte checkBlockType()
        {
            if (type == BlockType.FLAT)
                return 0;

            byte res = 0;

            for (int i = 0; i < 8; ++i)
            {
                for (int j = 0; j < 8; ++j)
                {
                    if (cells[i][j].getLayers() > res)
                        res = cells[i][j].getLayers();
                }
            }

            if (res == 1 && type == BlockType.MULTILEVEL)
            {
                //System.out.println("Wrong block Type: MULTILEVEL. Changing to COMPLEX [" + this.blockX + "," + this.blockY + "]");
                type = BlockType.COMPLEX;
                return 1;
            }

            return 0;
        }

        public void changeToComplexDontAddCells(short height)
        {
            type = BlockType.COMPLEX;
            flat_cell = null;
            cells = new GeoCell[8][];

            for (int i = 0; i < 8; ++i)
            {
                cells[i] = new GeoCell[8];

                for (int j = 0; j < 8; ++j)
                {
                    cells[i][j] = new GeoCell();
                    cells[i][j].fillDataMulti(new short[0], this);
                }
            }

        }

        public int checkLayersSort()
        {
            int result = 0;

            for (int i = 0; i < 8; ++i)
                for (int j = 0; j < 8; ++j)
                    result += cells[i][j].checkLayersSort();

            return result;
        }

        public byte getAmountOfNodes()
        {
            return type != BlockType.MULTILEVEL ? (byte)1 : cells[3][3].getLayers();
        }

        public short getNodeHeight(byte layer)
        {
            return this.type == BlockType.FLAT ? flat_cell.getZ(layer) : cells[3][3].getZ(layer);
        }
    }
}
