function Cook(){

	this.expires = null;
	this.path = null;
	this.domain = null;
	this.secure = false;

	this.getVal = function(offset) {
		var endstr = document.cookie.indexOf (";", offset);
		if (endstr == -1)
			endstr = document.cookie.length;
		return unescape(document.cookie.substring(offset, endstr));
	}
	
	this.get = function(name) {
		var arg = name + "=";
		var alen = arg.length;
		var clen = document.cookie.length;
		var i = 0;
		while (i < clen) {
			var j = i + alen;
			if (document.cookie.substring(i, j) == arg){
				return this.getVal(j);
			}
			i = document.cookie.indexOf(" ", i) + 1;
			if (i == 0) {
				break;
			}
		}
		return null;
	}
	
	this.set = function(name, value) {
		var argv = this.set.arguments;
		var argc = this.set.arguments.length;
		var expires = (argc > 2) ? argv[2] : this.expires;
		var path = (argc > 3) ? argv[3] : this.path;
		var domain = (argc > 4) ? argv[4] : this.domain;
		var secure = (argc > 5) ? argv[5] : this.secure;
		var cookie = name + "=" + escape (value) +
			((expires == null) ? "" : ("; expires=" + expires.toGMTString())) +
			((path == null) ? "" : ("; path=" + path)) +
			((domain == null) ? "" : ("; domain=" + domain)) +
			((secure == true) ? "; secure" : "");
		document.cookie = cookie;
	}
	
	
	this.remove = function(name) {
		var ex = new Date();
		ex.setTime(ex.getTime() - 1);  // This cookie is history
		var cval = this.get(name);
		this.set(name, cval, ex);
	}

}

  function hideVoter(){
    var d = new Date();
    d.setDate(d.getDate() + 1);
    var cook = new Cook();
    cook.set("rpg_club_l2top_vote", "1", d);
    document.getElementById('reminderDiv').style.display='none';
  }


  function hideEnter(){
    var d = new Date();
    d.setDate(d.getDate() + 60);
    var cook = new Cook();
    cook.set("rpg_club_enter", "1", d);
  }

  function hideMus(){
    var d = new Date();
    d.setDate(d.getDate() + 60);
    var cook = new Cook();
    cook.set("rpg_club_mus", "1", d);
    document.getElementById('musik').style.display='none';
  }